/**
 * @fileoverview api to be invoked by external script
 * @author sunnyjiang
 * @version 1.1
 */

/**
 * @namespace api
 */
var api = {};

/**
 * add a new tab, only for browser invoke, no need to invoke Browser.tabs.create
 */
api.addTab = function(url, title) {
	tabManager.newTab(url, title);
};

/**
 * change url of address input 
 * 客户端tab id从1开始，需要减1
 */
api.setAddress = function(id, url) {
	var tab = tabManager.getTab(id - 1);
	tabManager.setUrl(tab, url);
	
	if((id - 1) == tabManager.getCurrentTabIndex())
		$('#address-input').val(url);		
};

/**
 * change title
 * 客户端tab id从1开始，需要减1
 */
api.setTitle = function(id, title) {
	tabManager.setTitle(id - 1, title);
};

/**
 * TODO 添加右侧工具栏按钮
 */
api.addLeftToolbarButton = function(){

};

/**
 * Page Box 位置
 */
api.getPageOffset = function() {
	var page_box_offset = $('#page-box').offset();
	return {'x': page_box_offset.top, 'y': page_box_offset.left};	
};

/**
 * Page Box 长宽
 */
api.getPageSize = function() {
	var page_box = $('#page-box');
	return {'width': page_box.width(), 'height': page_box.height()};
};

/**
 * 浏览器调用改变tab前进后退状态
 * @param go & forward: boolean
 */
api.setTabStatus = function(id, back, forward) {
	var tab = tabManager.getTab(id - 1);
	tab.attr('back', back);
	tab.attr('forward', forward);
	
	// 如果是当前tab，立即改变按钮状态
	if(id - 1 == tabManager.getCurrentTabIndex())
		view.setBackAndForwardButtonStatus();
};

/**
 * 判断坐标点是否可以拖拽
 */
api.isDragable = function() {
	$(document).mouseover(function() {
		// 三个区域：body，tab-wrapper，head-top-box
		if(event.target.tagName == 'BODY' || event.target.id == 'tab-wrapper' || event.target.id == 'head-top-box')
			return 1;
	});
	return 0;
};